
# repFrac.py
'''
  Find the repeating decimal sequence in the fraction
  numer/denom, its length, and distribution of digits
'''

import decimal
from decimal import Decimal as D
import collections


def findRepSeq(numer, denom):
  divResult = ""  # holds the on-going division result
  remPosMap = {} 
  ''' key: Remainder
      value: its position in divResult
  '''
  rem = numer % denom
  # Keep finding remainder until either
  # remainder becomes 0 or the sequence repeats
  while ((rem != 0) and (rem not in remPosMap)):
    remPosMap[rem] = len(divResult)
    rem = rem * 10
    quotient = rem // denom
    divResult += str(quotient)
    rem = rem % denom
  if (rem == 0):
    return None
  else:
    return divResult[remPosMap[rem]:]

if __name__ == "__main__":
  numer, denom = map(int, input("numer denom=? ").split())
  decimal.getcontext().prec = 100
  print("Fraction:", D(numer)/D(denom))
  seq = findRepSeq(numer, denom)
  if (seq == None):
    print("No repeating sequence")
  else:
    print("Repeating sequence length:", len(seq))
    print("Repeating sequence is", seq)
    c = collections.Counter(seq)
    cSort = dict(sorted(c.items()))
    print(cSort)
